;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                                       ;;
;;  AutoIt Version: 3.3.0.0                                                              ;;
;;                                                                                       ;;
;;  Template AutoIt script.                                                              ;;
;;                                                                                       ;;
;;  AUTHOR:  TheSaint <thsaint@ihug.com.au>                                              ;;
;;                                                                                       ;;
;;  SCRIPT FUNCTION: Program that works with Sigil ebook editor.                         ;;
;;                                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; FUNCTIONS
; BackupEbookFile(), CheckIfBackupOptionsCorrect(), SetBackupOptions()

; Script generated by AutoBuilder 0.9 Prototype

#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <Misc.au3>
#include <WindowsConstants.au3>
#include <ButtonConstants.au3>
#include <Array.au3>
#include <Date.au3>

_Singleton("sigil-assistant-thsaint")

Global $Button_clip, $Button_del, $Button_exit, $Button_fwd, $Button_info, $Button_num, $Button_nxt
Global $Button_sav, $Button_space, $Button_try, $Button_up, $Button_win
Global $Radio_add, $Radio_cycle, $Radio_slash

Global $actwin, $ans, $backups, $bakpth, $clip, $cliptxt, $cursor, $dll, $ebook, $find, $height, $inifle
Global $last, $left, $numb, $pth, $saved, $secs, $SigilAss, $succ, $top, $w, $width, $wins, $wintit

$width = 230
$left = @DesktopWidth - ($width + 6)
$height = 260
$top = @DesktopHeight - ($height + 60)

$SigilAss = GuiCreate("Sigil Assistant v1.5", $width, $height, $left, $top, $WS_OVERLAPPED + $WS_CAPTION _
			+ $WS_SYSMENU + $WS_VISIBLE + $WS_CLIPSIBLINGS + $WS_MINIMIZEBOX, $WS_EX_TOPMOST)
;
; CONTROLS
$Button_num = GuiCtrlCreateButton("Find Number", 10, 10, 80, 40)
$Button_try = GuiCtrlCreateButton("Retry", 95, 10, 40, 40)
$Button_win = GuiCtrlCreateButton("Get Window", 145, 10, 75, 40)
$Button_fwd = GuiCtrlCreateButton("Delete Forward", 10, 60, 100, 40)
$Button_del = GuiCtrlCreateButton("Delete", 120, 60, 60, 40)
$Button_up = GuiCtrlCreateButton("Up", 190, 60, 30, 40)
$Button_sav = GuiCtrlCreateButton("SAVE", 10, 110, 60, 40)
$Button_space = GuiCtrlCreateButton("Back Space", 80, 110, 80, 40)
$Button_info = GuiCtrlCreateButton("Info", 170, 110, 50, 40)
$Button_nxt = GuiCtrlCreateButton("Next Page", 10, 160, 90, 40)
$Button_clip = GuiCtrlCreateButton("Clip", 110, 160, 50, 40)
$Button_exit = GuiCtrlCreateButton("EXIT", 170, 160, 50, 40)
$Group_clip = GUICtrlCreateGroup("Clip Options", 10, 210, 210, 40)
$Radio_slash = GUICtrlCreateRadio("Underslashes", 20, 225, 80, 20)
GUICtrlSetTip($Radio_slash, "Replace spaces with underslashes in text on the clipboard!")
$Radio_add = GUICtrlCreateRadio("Add To", 110, 225, 55, 20)
GUICtrlSetTip($Radio_add, "Add text To text on the clipboard!")
$Radio_cycle = GUICtrlCreateRadio("Use", 175, 225, 40, 20)
GUICtrlSetTip($Radio_cycle, "Cycle through text on the clipboard to use!")
;
; SETTINGS
$inifle = @ScriptDir & "\Settings.ini"
;
GUICtrlSetState($Button_del, $GUI_DISABLE)
GUICtrlSetState($Button_fwd, $GUI_DISABLE)
GUICtrlSetState($Button_sav, $GUI_DISABLE)
;
$wintit = ""
$actwin = IniRead($inifle, "Active Window", "handle", "")
If $actwin <> "" Then
	$wins = WinList()
	For $w = 1 To $wins[0][0]
		; Compare Handles
		If $wins[$w][1] = $actwin Then
			$wintit = $wins[$w][0]
			If $wintit = IniRead($inifle, "Active Window", "title", "") Then
				; Title matches previously used one.
				$actwin = $wins[$w][1]
			Else
				$wintit = ""
			EndIf
			ExitLoop
		EndIf
	Next
EndIf
If $wintit = "" Then
	$actwin = ""
	GUICtrlSetState($Button_try, $GUI_DISABLE)
	GUICtrlSetState($Button_num, $GUI_DISABLE)
	GUICtrlSetState($Button_nxt, $GUI_DISABLE)
	GUICtrlSetState($Button_space, $GUI_DISABLE)
Else
	MsgBox(262208, "Active Window Title", $wintit & " (" & $actwin & ")", 0, $SigilAss)
	$backups = IniRead($inifle, "Epub File", "backups", "")
	If $backups = "" Then
		SetBackupOptions()
	ElseIf $backups = 1 Then
		CheckIfBackupOptionsCorrect()
	EndIf
EndIf
;
GUICtrlSetState($Radio_slash, $GUI_CHECKED)
;
$cliptxt = IniRead($inifle, "Clipboard", "array", "")


GuiSetState()
While 1
	$msg = GuiGetMsg()
	Select
	Case $msg = $GUI_EVENT_CLOSE Or $msg = $Button_exit
		GUIDelete($SigilAss)
		ExitLoop
	Case $msg = $Button_win
		If _IsPressed("10") Then
			SetBackupOptions()
		Else
			WinSetState($SigilAss, "", @SW_MINIMIZE)
			$ans = MsgBox(262177, "Assign Active Window", _
				"You need to specify a Sigil window to work with." & @LF & _
				"To do this, close this dialog using the OK button," & @LF & _
				"then click on (activate/restore/start) the desired" & @LF & _
				"window, then right click on it's title bar. Success," & @LF & _
				"should present you with a title dialog.  After that," & @LF & _
				"and until the program closes, that window will be" & @LF & _
				"the one the other buttons work with." & @LF & @LF & _
				"EDIT button allows a reselection of the window.", 0, $SigilAss)
			If $ans = 1 Then
				$dll = DllOpen("user32.dll")
				Sleep(500)
				While 1
					If _IsPressed("02", $dll) Then
						$actwin = WinGetHandle("[ACTIVE]", "")
						If @error <> 1 And $actwin <> "" Then
							IniWrite($inifle, "Active Window", "handle", $actwin)
							MsgBox(262208, "Active Window Handle", $actwin, 0, $SigilAss)
							Sleep(500)
							GUICtrlSetState($Button_num, $GUI_ENABLE)
							If GUICtrlGetState($Button_try) = 144 Then
								GUICtrlSetState($Button_try, $GUI_ENABLE)
							EndIf
							GUICtrlSetState($Button_nxt, $GUI_ENABLE)
							GUICtrlSetState($Button_space, $GUI_ENABLE)
							;$wintit = WinGetTitle("[ACTIVE]", "")
							;$wintit = WinGetTitle("[LAST]", "")
							;$wintit = WinGetTitle($actwin, "")
							$wins = WinList()
							For $w = 1 To $wins[0][0]
								If $wins[$w][1] = $actwin Then
									$wintit = $wins[$w][0]
									ExitLoop
								EndIf
							Next
							;MsgBox(262208, "Active Window Title", $wintit, 0)
							MsgBox(262208, "Active Window Title", $wintit & " (" & $actwin & ")", 0, $SigilAss)
							IniWrite($inifle, "Active Window", "title", $wintit)
							;
							CheckIfBackupOptionsCorrect()
						Else
							MsgBox(262192, "Error", "Active window could not be determined.", 0, $SigilAss)
						EndIf
						ExitLoop
					ElseIf _IsPressed("11", $dll) Then
						ExitLoop
					Else
						Sleep(500)
					EndIf
				WEnd
				DllClose($dll)
			EndIf
			WinSetState($SigilAss, "", @SW_RESTORE)
		EndIf
	Case $msg = $Button_up
		If $actwin = "" Then
			
		Else
			If WinExists($actwin, "") Then
				$succ = WinActivate($actwin, "")
				If $succ = 1 Then
					Send("{UP}")
				Else
					MsgBox(262192, "Error", "Window could not be activated.", 0, $SigilAss)
				EndIf
			Else
				MsgBox(262192, "Error", "Active window could not be found.", 0, $SigilAss)
			EndIf
		EndIf
	Case $msg = $Button_space
		If $actwin = "" Then
			
		Else
			If WinExists($actwin, "") Then
				$succ = WinActivate($actwin, "")
				If $succ = 1 Then
					Send("{BACKSPACE}")
					Send("{SPACE}")
					Send("{HOME}")
					;If GUICtrlGetState($Button_sav) = $GUI_DISABLE Then
					If GUICtrlGetState($Button_sav) = 144 Then
						GUICtrlSetState($Button_sav, $GUI_ENABLE)
					EndIf
				Else
					MsgBox(262192, "Error", "Window could not be activated!", 0, $SigilAss)
				EndIf
			Else
				MsgBox(262192, "Error", "Active window could not be found!", 0, $SigilAss)
			EndIf
		EndIf
	Case $msg = $Button_sav
		If $actwin = "" Then
			
		Else
			If WinExists($actwin, "") Then
				$succ = WinActivate($actwin, "")
				If $succ = 1 Then
					$cursor = MouseGetCursor()
					Send("^s")
					GUICtrlSetState($Button_sav, $GUI_DISABLE)
					If $backups = 1 Then
						; Need a short delay for Save to finish, before backing up.
						GUISetCursor(1, 1, $SigilAss)
						Sleep(3000)
						GUISetCursor($cursor, 1, $SigilAss)
						$saved = IniRead($inifle, "Epub File", "saved", "")
						If $saved = "" Then
							If FileExists($ebook) Then
								BackupEbookFile()
							Else
								MsgBox(262192, "Error", "Ebook not be found for backup!", 0, $SigilAss)
							EndIf
						Else
							; If longer than 5 minutes since last backup, then create next backup.
							$secs = _DateDiff("s", $saved, _NowCalc())
							If $secs > 300 Then BackupEbookFile()
						EndIf
					EndIf
				EndIf
			EndIf
		EndIf
	Case $msg = $Button_nxt
		If $actwin = "" Then
			
		Else
			If WinExists($actwin, "") Then
				$succ = WinActivate($actwin, "")
				If $succ = 1 Then
					Send("!{PGDN}")
					Sleep(250)
					; Close other windows to avoid eventual TAB count issue after ESC (too many pages open).
					Send("^!w")
					;Send("^+t")
					Sleep(100)
					Send("^{HOME}")
				EndIf
			EndIf
		EndIf
	Case $msg = $Button_num Or $msg = $Button_try
		If $actwin = "" Then
			
		Else
			If WinExists($actwin, "") Then
				$last = IniRead($inifle, "Number Search", "last", "1")
				If $msg = $Button_try Then
					; Retry
					$last = $last - 1
					;IniWrite($inifle, "Number Search", "last", $numb)
				EndIf
				$numb = InputBox("Number Search", "Number to search for next. CTRL = less 1.", $last, "", 250, 130, $left - 20, $top - 130, "", $SigilAss)
				If Not @error And $numb <> "" And StringIsDigit($numb) Then
					If _IsPressed("11") Then
						$numb = $numb - 1
						MsgBox(262208, "Number Reduction", $numb, 0, $SigilAss)
					EndIf
					IniWrite($inifle, "Number Search", "last", $numb)
					$succ = WinActivate($actwin, "")
					If $succ = 1 Then
						If $find = "" Then
							Send("^f")
							Sleep(100)
							Send($numb)
							Sleep(100)
							Send("^g")
							$numb = $numb + 1
							IniWrite($inifle, "Number Search", "last", $numb)
							Send("{ESC}")
							Send("+{TAB 2}")
							GUICtrlSetState($Button_del, $GUI_ENABLE)
							GUICtrlSetState($Button_fwd, $GUI_ENABLE)
							GUICtrlSetState($Button_sav, $GUI_ENABLE)
						EndIf
					EndIf
				ElseIf _IsPressed("11") Then
					$numb = $last - 1
					IniWrite($inifle, "Number Search", "last", $numb)
					MsgBox(262208, "Number Reduction", $numb, 0, $SigilAss)
				EndIf
				If GUICtrlGetState($Button_try) = 144 Then
					GUICtrlSetState($Button_try, $GUI_ENABLE)
				EndIf
			EndIf
		EndIf
	Case $msg = $Button_info
		; Program Information
		$ans = MsgBox(262465, "Program Information", _
			"This program incrementally searches for page numbers, starting at the one specified." & @LF & @LF & _
			"It works with an epub file opened in Sigil, and gives quick easy buttons to find and" & @LF & _
			"remove the page numbers, because they are not wanted in an ebook." & @LF & @LF & _
			"Please ensure that 'Current File' is selected in Sigil's Find dialog 'Mode' options, as" & @LF & _
			"well as Sigil being in the 'Book View' state, not 'Code View'." & @LF & @LF & _
			"It is recommended that you save at the end of each page file, before moving onto" & @LF & _
			"the next page. The steps you take generally, are." & @LF & @LF & _
			"Initial Setup" & @LF & _
			"---------------" & @LF & _
			"(1) Get Window." & @LF & @LF & _
			"Repeatedly   (see more information for specifics)" & @LF & _
			"--------------" & @LF & _
			"(2) Find Number (or Retry)." & @LF & _
			"(3) Delete Forward (or Delete)." & @LF & @LF & _
			"End Of Page" & @LF & _
			"---------------" & @LF & _
			"(4) SAVE." & @LF & _
			"(5) Next Page." & @LF & @LF & _
			"NOTES - To prevent tabbing issues, only the working page stays open, with the" & @LF & _
			"others automatically closed on a Next Page selection. Holding down CTRL while" & @LF & _
			"exiting the Number input query, decreases the number by one (Cancel included)." & @LF & @LF & _
			"Click OK to see more information.", 0, $SigilAss)
		If $ans = 1 Then
			MsgBox(262208, "Program Information (cont.)", _
				"The 'Delete Forward' button will relink before and after lines, after the" & @LF & _
				"number is removed, while the 'Delete' button doesn't relink lines, and" & @LF & _
				"may leave a blank line or space behind, after the number removal." & @LF & _
				"The 'Back Space' button will just relink before and after lines." & @LF & @LF & _
				"The RETRY button will search again for the Last number used." & @LF & _
				"The UP button just moves the cursor up, line by line." & @LF & @LF & _
				"The CLIP button operates according to the 'Clipboard Options' Selection." & @LF & _
				"(1) Replace spaces in the clipboard text with underslashes." & @LF & _
				"(2) Add text on the clipboard to a stored delimited text container." & @LF & _
				"(3) Use stored delimited text by cycling it to the clipboard." & @LF & _
				"NOTE - The stored text uses the pipe '|' character as delimiter, with the" & @LF & _
				"first portion always returned, then removed from the stored text." & @LF & @LF & _
				"The CLIP button also has two other alternate processes, that occur if" & @LF & _
				"CTRL (clear stored text) or SHIFT (show stored text), are held down" & @LF & _
				"while it is clicked." & @LF & @LF & _
				"To modify the backup settings, hold down the SHIFT key while clicking" & @LF & _
				"the 'Get Window' button." & @LF & @LF & _
				" September 2016 - created by TheSaint.", 0, $SigilAss)
		EndIf
	Case $msg = $Button_fwd
		If $actwin = "" Then
			
		Else
			If WinExists($actwin, "") Then
				$succ = WinActivate($actwin, "")
				If $succ = 1 Then
					Send("{BACKSPACE}")
					Send("{RIGHT}")
					Send("{BACKSPACE}")
					GUICtrlSetState($Button_del, $GUI_DISABLE)
					GUICtrlSetState($Button_fwd, $GUI_DISABLE)
				EndIf
			EndIf
		EndIf
	Case $msg = $Button_del
		If $actwin = "" Then
			
		Else
			If WinExists($actwin, "") Then
				$succ = WinActivate($actwin, "")
				If $succ = 1 Then
					Send("{BACKSPACE}")
					GUICtrlSetState($Button_del, $GUI_DISABLE)
					GUICtrlSetState($Button_fwd, $GUI_DISABLE)
				EndIf
			EndIf
		EndIf
	Case $msg = $Button_clip
		; Clipboard options.
		If _IsPressed("11") Then
			; Clear stored clipboard text.
			$cliptxt = ""
			IniWrite($inifle, "Clipboard", "array", $cliptxt)
		ElseIf _IsPressed("10") Then
			; Display stored clipboard text.
			MsgBox(262208, "Clipboard String", $cliptxt, 0, $SigilAss)
		Else
			$clip = ClipGet()
			If GUICtrlRead($Radio_slash) = $GUI_CHECKED Then
				; Replace spaces with underslashes to text on the clipboard.
				$clip = StringReplace($clip, " ", "_")
			Else
				If GUICtrlRead($Radio_add) = $GUI_CHECKED Then
					; Add text To text on the clipboard
					If $cliptxt = "" Then
						$cliptxt = $clip
					Else
						$cliptxt = $cliptxt & "|" & $clip
					EndIf
				ElseIf GUICtrlRead($Radio_cycle) = $GUI_CHECKED Then
					; Cycle through text on the clipboard to use
					If $cliptxt <> "" Then
						$cliptxt = StringSplit($cliptxt, "|")
						$clip = $cliptxt[1]
						_ArrayDelete($cliptxt, 1)
						$cliptxt = _ArrayToString($cliptxt, "|", 1)
					EndIf
				EndIf
				IniWrite($inifle, "Clipboard", "array", $cliptxt)
			EndIf
			ClipPut($clip)
		EndIf
	Case Else
		;;;
	EndSelect
WEnd

Exit

Func BackupEbookFile()
	$saved = _NowCalc()
	IniWrite($inifle, "Epub File", "saved", $saved)
	$saved = StringReplace($saved, "/", "")
	$saved = StringReplace($saved, ":", "")
	$saved = StringReplace($saved, " ", "")
	$bakpth = StringReplace($ebook, ".epub", "_" & $saved & ".epub")
	FileCopy($ebook, $bakpth)
EndFunc ;=> BackupEbookFile

Func CheckIfBackupOptionsCorrect()
	$ebook = IniRead($inifle, "Epub File", "path", "")
	If $ebook = "" Or Not FileExists($ebook) Then
		SetBackupOptions()
	Else
		; Query if right ebook file for backups
		$ans = MsgBox(262177, "Backup Query", _
			"The following specified ebook file path is set for backups." & @LF & @LF & _
			$ebook & @LF & @LF & _
			"OK = This is correct.      CANCEL = No backups.", 0, $SigilAss)
		If $ans = 2 Then
			SetBackupOptions()
		EndIf
	EndIf
EndFunc ;=> CheckIfBackupOptionsCorrect

Func SetBackupOptions()
	$pth = FileOpenDialog("Select the file you are working with, so backups can occur.", "", "Ebook file (*.epub)", 3, "", $SigilAss)
	If @error <> 1 And StringMid($pth, 2, 2) = ":\" Then
		$ebook = $pth
		IniWrite($inifle, "Epub File", "path", $ebook)
		$backups = 1
	Else
		$backups = 4
	EndIf
	IniWrite($inifle, "Epub File", "backups", $backups)
EndFunc ;=> SetBackupOptions

